<?php

namespace App\Livewire\Pages;

use Illuminate\Support\Facades\Validator;
use Livewire\Component;
use App\Services\SettingService;
use App\Services\MailService;
class ContactUs extends Component
{
    public $first_name = "";
    public $last_name = "";
    public $email = "";
    public $mobile_number = "";
    public $message = "";
    public $captcha = "";

    public function refreshCaptcha()
    {
        $this->dispatch('refreshCaptcha');
    }

    public function render()
    {
        $web_settings = app(SettingService::class)->getSettings('web_settings', true);
        $contact_us = app(SettingService::class)->getSettings('contact_us', true);

        return view('livewire.' . config('constants.theme') . '.pages.contact-us', [
            "web_settings" => json_decode($web_settings, true),
            'contact_us' => json_decode($contact_us, true)
        ])->title("Contact us |");
    }

    public function send_contact_us_email()
    {
        $validatedData = $this->validate([
            'first_name' => 'required',
            'last_name' => 'required',
            'mobile_number' => 'required|numeric',
            'email' => 'required|email',
            'message' => 'required',
            'captcha' => 'required|captcha'
        ], [
            'first_name.required' => 'First Name is required.',
            'last_name.required' => 'Last Name is required.',
            'mobile_number.required' => 'Mobile Number is required.',
            'email.required' => 'Email ID is required.',
            'message.required' => 'Message is required.',
            'captcha.required' => 'Captcha is required.',
            'captcha.captcha' => 'Invalid Captcha Code.'
        ]);

        $from = $this->email;
        $subject = "Contact Us Inquiry from " . $this->first_name . " " . $this->last_name;
        $emailMessage = "Mobile: " . $this->mobile_number . "\n\n" . $this->message;
        try {
            $mail = app(MailService::class)->sendContactUsMail($from, $subject, $emailMessage, "");
        } catch (\Throwable $th) {
            $this->dispatch('showError', 'Something Went Wrong, Please Try Again Later.');
            return $this->addError('mailError', 'Something Went Wrong, Please Try Again Later.');
        }
        if ($mail['error'] == true) {
            $response['error'] = true;
            $response['message'] = "Cannot send mail. You can try to send mail manually.";
            $response['data'] = $mail['message'];
            // 🔴 Show REAL mail error
                // $this->dispatch('showError', $mail['message']);
                // dd($mail['message']);
            session()->flash('message', $response['message']);
            //  return;
            return $this->redirect('/contact-us', navigate: true);
        } else {
            $response['error'] = false;
            $response['message'] = 'Mail sent successfully.';
            $response['data'] = array();
            session()->flash('message', $response['message']);
            return $this->redirect('/contact-us', navigate: true);
        }
    }
}
