<?php

namespace App\Livewire\MyAccount;

use Livewire\Component;
use Illuminate\Support\Facades\Auth;
use App\Services\SettingService;
class Wallet extends Component
{
    protected $listeners = ['refreshComponent'];

    public function render()
    {
        $user = Auth::user();
        $user = $this->get_user_info();
        $payment_method = app(SettingService::class)->getSettings('payment_method', true);
        $payment_method = json_decode($payment_method);
        return view('livewire.' . config('constants.theme') . '.my-account.wallet', [
            'user_info' => $user,
            'payment_method' => $payment_method,
        ])->title("Wallet |");
    }

    public function get_user_info()
    {
        return Auth::user();
    }

    public function refreshComponent()
    {
        $this->dispatch('$refresh');
    }
}
