<?php

namespace App\Livewire;

use App\Http\Controllers\BrandController;
use App\Http\Controllers\CategoryController;
use App\Models\Blog;
use App\Models\Brand;
use App\Models\Category;
use App\Models\CategorySliders;
use App\Models\Offer;
use App\Models\Section;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Livewire\Component;
use App\Services\TranslationService;
use App\Services\ProductService;
use App\Services\ComboProductService;
use App\Services\StoreService;
use App\Services\MediaService;
use App\Services\SettingService;
use App\Services\MailService;
use Debugbar;
class Home extends Component
{
    public $user_id;
    public function __construct()
    {
        $this->user_id = Auth::user() != '' ? Auth::user()->id : NUll;
    }
    public $store_id = "";
    public function render(Request $request)
    {
        $store_id = session('store_id');
        $this->store_id = $store_id;
        $sliders = getSliders("", "", "", $store_id);
        Debugbar::info($sliders);
        $categoryController = app(CategoryController::class);
        $categories = $categoryController->getCategories(sort: 'row_order', order: "ASC", store_id: $store_id);
        $categories = $categories->original;
        // dd($categories);
        $BrandController = app(BrandController::class);
        $brands = $BrandController->getBrands("", "", "", "", "ASC", $store_id);
// dd($brands);
        $categories_section = $this->getCategoriesSection();
        // dd($categories_section);
        $sections = $this->sections();
        $offers = $this->getOffers($store_id);
        // dd($offers);
        $settings = app(SettingService::class)->getSettings('web_settings', true);
        $settings = json_decode($settings);
        $rating = app(ProductService::class)->fetchRating('', '', 8, 0, '', 'desc', '', 1);
        $ratings = isset($rating) && !empty($rating) ? $rating['product_rating'] : [];
        $blogs = fetchDetails(Blog::class, ['store_id' => $store_id, 'status' => 1], '*');
        $blogs_count = count($blogs);
        $store_settings = app(StoreService::class)->getStoreSettings();

        // Fetch Sellers
        $seller_listing = fetchDetails(\App\Models\SellerStore::class, ['store_id' => $store_id]);
        $sellers = [
            'listing' => [],
            'links' => ''
        ];

        if (count($seller_listing) >= 1) {
            $total_products = count($seller_listing);
            $products = collect($seller_listing);
            $page = request()->get('page', 1);
            $perPage = 12;

            $paginator = new \Illuminate\Pagination\LengthAwarePaginator(
                $products->forPage((int) $page, (int) $perPage),
                $total_products,
                (int) $perPage,
                (int) $page,
                ['path' => url()->current()]
            );

            $sellers['listing'] = $paginator->items();
            $sellers['links'] = $paginator->links();
        }

        $home_theme = getHomeTheme($store_settings);
                $store_settings = app(StoreService::class)->getStoreSettings();


        // return view('livewire.' . config('constants.theme') . '.home.home', [
        return view($home_theme, [
            'sliders' => $sliders,
            'categories' => $categories,
            'brands' => $brands,
            'sections' => $sections,
            'offers' => $offers,
            'categories_section' => $categories_section,
            'settings' => $settings,
            'ratings' => $ratings,

            'blogs' => $blogs,
            'blogs_count' => $blogs_count,
            'Sellers' => $sellers,
        ])->layoutData([
            'title' => "Home |",
        ]);
    }
    public function getOffers($store_id)
    {
        $offers = fetchDetails(Offer::class, ['store_id' => $store_id], '*');
        // dd($offers);
        $language_code = app(TranslationService::class)->getLanguageCode();
        foreach ($offers as $key => $offer) {
            $image =
                !empty($offer->image) &&
                file_exists(public_path(config('constants.MEDIA_PATH') . $offer->image))
                ? app(MediaService::class)->getImageUrl($offer->image)
                : app(MediaService::class)->getImageUrl('offerPlaceHolder.png', '', '', 'image', 'NO_USER_IMAGE');
            $banner_image =
                !empty($offer->banner_image) &&
                file_exists(public_path(config('constants.MEDIA_PATH') . $offer->banner_image))
                ? app(MediaService::class)->getImageUrl($offer->banner_image)
                : app(MediaService::class)->getImageUrl('offerPlaceHolder.png', '', '', 'image', 'NO_USER_IMAGE');
            $offers[$key]->image = $image;
            $offers[$key]->title = app(TranslationService::class)->getDynamicTranslation(Offer::class, 'title', $offers[$key]->id, $language_code);
            $offers[$key]->banner_image = $banner_image;
            if ($offer->type == "categories") {
                $link = fetchDetails(Category::class, ['id' => $offer->type_id], 'slug');
                // dd(!empty($link));
                // dd($link);
                if ($link->isNotEmpty()) {
                    $offers[$key]->link = customUrl('categories/' . $link[0]->slug . '/products');
                }
            } elseif ($offer->type == "brand") {
                $link = fetchDetails(Brand::class, ['id' => $offer->type_id], 'slug');
                if ($link->isNotEmpty()) {
                    $offers[$key]->link = customUrl('products/?brand=' . $link[0]->slug);
                }
            }
        }
        // dd($offers);
        return $offers;
    }
    public function getCategoriesSection()
    {
        $store_id = session('store_id');
        $sliders = fetchDetails(CategorySliders::class, ['store_id' => $store_id, 'status' => 1], '*');
        $language_code = app(TranslationService::class)->getLanguageCode();
        if (count($sliders) >= 1) {
            foreach ($sliders as $key => $slider) {
                $categories_detail = fetchDetails(Category::class, where_in_key: "id", where_in_value: explode(",", $slider->category_ids));
                $sliders[$key]->banner_image = app(MediaService::class)->dynamic_image(app(MediaService::class)->getImageUrl($slider->banner_image), 620);
                $sliders[$key]->title =  app(TranslationService::class)->getDynamicTranslation(CategorySliders::class, 'title', $sliders[$key]->id, $language_code);

                foreach ($categories_detail as $k => $details) {
                    $categories_detail[$k]->image = app(MediaService::class)->dynamic_image(app(MediaService::class)->getImageUrl($details->image), 400);
                    $categories_detail[$k]->name =  app(TranslationService::class)->getDynamicTranslation(Category::class, 'name', $categories_detail[$k]->id, $language_code);
                    $categories_detail[$k]->banner = app(MediaService::class)->dynamic_image(app(MediaService::class)->getImageUrl($details->banner), 400);
                }
                $sliders[$key]->categories_detail = $categories_detail;
            }
        }
        return $sliders;
    }

    public function sections()
    {
        $store_id = session('store_id');
        $limit =  12;
        $offset =  0;
        $sections = Section::where('store_id', $store_id)
            ->orderBy('row_order')
            ->offset($offset)
            ->limit($limit)
            ->get();
        $language_code = app(TranslationService::class)->getLanguageCode();
        $filters['show_only_active_products'] = true;
        if (!empty($sections)) {
            for ($i = 0; $i < count($sections); $i++) {
                $product_ids = explode(',', (string)$sections[$i]->product_ids);
                $product_ids = array_filter($product_ids);
                $product_categories = (isset($sections[$i]->categories) && !empty($sections[$i]->categories) && $sections[$i]->categories != NULL) ? explode(',', $sections[$i]->categories ?? '') : null;
                if (isset($sections[$i]->product_type) && !empty($sections[$i]->product_type)) {
                    $filters['product_type'] = (isset($sections[$i]->product_type)) ? $sections[$i]->product_type : null;
                }
                if ($sections[$i]->style == "style_1") {
                    $limit = 12;
                } elseif ($sections[$i]->style == "style_2" || $sections[$i]->style == "style_3") {
                    $limit = 6;
                }
                if ($sections[$i]->product_type === "custom_combo_products") {
                    $combo_products = app(ComboProductService::class)->fetchComboProduct(user_id: $this->user_id, id: (isset($product_ids)) ? $product_ids : null, limit: $limit, store_id: $store_id);
                } else {
                    $products = app(ProductService::class)->fetchProduct(user_id: $this->user_id, filter: (isset($filters)) ? $filters : null, id: (isset($product_ids)) ? $product_ids : null, category_id: $product_categories, limit: $limit, store_id: $this->store_id, is_detailed_data: 0);

                }
                $sections[$i]->title =  app(TranslationService::class)->getDynamicTranslation(Section::class, 'title', $sections[$i]->id, $language_code);
                $sections[$i]->short_description =  app(TranslationService::class)->getDynamicTranslation(Section::class, 'short_description', $sections[$i]->id, $language_code);
                $sections[$i]->banner_image = app(MediaService::class)->dynamic_image(app(MediaService::class)->getMediaImageUrl($sections[$i]->banner_image), 800);
                $sections[$i]->slug =  Str::slug($sections[$i]->title);
                $sections[$i]->filters = (isset($products['filters'])) ? $products['filters'] : [];
                if ($sections[$i]->product_type === "custom_combo_products") {
                    $sections[$i]->product_details = (object)$combo_products['combo_product'];
                } else {
                    $sections[$i]->product_details = (object)$products['product'];
                }
            }
        }
        return $sections;
    }

    public function sendMailTemplate($to, $template_key, $data = ['username' => 'jay', 'appname' => 'Ezeemart'], $givenLanguage = "")
    {
        $response = app(MailService::class)->sendMailTemplate(to: $to, template_key: $template_key, data: $data);
        return $response;
    }
}
