<?php

namespace App\Livewire\Cart;

use App\Http\Controllers\AddressController;
use App\Models\TimeSlot;
use App\Models\Zipcode;
use App\Services\PromoCodeService;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use App\Services\CartService;
use App\Services\DeliveryService;
use App\Services\CurrencyService;
use App\Services\SettingService;
use Debugbar;
class Checkout extends Component
{

    protected $listeners = ['refreshComponent', 'get_selected_address', 'get_selected_promo', 'is_wallet_use'];
    public $user_id = "";
    public function __construct()
    {
        $this->user_id = Auth::user() != '' ? Auth::user()->id : NUll;
    }
    public $store_id = "";
    public $product_type = "";
    public $cart_count = "";
    public $selected_address_id = "";
    public $selected_address = "";
    public $selected_promo_code = "";
    public $is_wallet_use = false;
    public $wallet_used_balance = "";
    public $buy_now_variant_id = "";
    public $buy_now_product_type = "";

    public function mount()
    {
        $store_id = session('store_id');
        $this->store_id = $store_id;

        // Check if this is a "Buy Now" checkout
        $this->buy_now_variant_id = request()->query('buy_now_variant_id', '');
        $this->buy_now_product_type = request()->query('product_type', '');

        $cart_data = $this->get_user_cart($this->user_id, $store_id);
        if (count($cart_data) < 1) {
            return $this->redirect(customUrl('/'), true);
        }
    }

    public function render()
    {
        $store_id = $this->store_id;
        $addressController = app(AddressController::class);
        $addresses = $addressController->getAddress($this->user_id);
        // dd($addresses);
        $default_address = [];

        if (!empty($addresses)) {
            if (isset($this->selected_address_id) && !empty($this->selected_address_id)) {
                $default_address = $this->selected_address;
            } else {
                $default_address = array_values(array_filter($addresses->all(), function ($item) {
                    return $item->is_default == 1;
                }));
            }

            if (empty($default_address)) {
                $default_address = $addresses;
            }
        }

        $user_details = fetchUsers($this->user_id);
        $wallet_balance = $user_details['balance'];

        $promo_codes = app(abstract: PromoCodeService::class)->getPromoCodes(store_id: $store_id);

        // ⭐ If "Buy Now" mode, get cart data for only that product
        if (!empty($this->buy_now_variant_id) && !empty($this->buy_now_product_type)) {
            // Get cart data filtered to only the buy_now product
            $cart_data = app(CartService::class)->getCartTotal(
                $this->user_id,
                $this->buy_now_variant_id, // Filter by variant_id
                false, // is_saved_for_later
                ($default_address[0]->id ?? ""),
                $store_id
            );
        } else {
            // Normal checkout - get all cart items
            $cart_data = $this->get_user_cart($this->user_id, $store_id, ($default_address[0]->id ?? ""));
        }

        if (count($cart_data) < 1 || empty($cart_data['cart_items'])) {
            return $this->redirect(customUrl('/'), true);
        }

        $final_total = $cart_data['overall_amount'];
        if (isset($this->selected_promo_code) && !empty($this->selected_promo_code)) {
            $is_promo_valid = app(abstract: PromoCodeService::class)->validatePromoCode($this->selected_promo_code, $this->user_id, $final_total, 1);
            if ($is_promo_valid->original['error'] == false) {
                $is_promo_valid->original['data'][0]->final_discount = app(CurrencyService::class)->formateCurrency($is_promo_valid->original['data'][0]->final_discount);
                $final_total = $is_promo_valid->original['data'][0]->final_total;
                $is_promo_valid->original['data'][0]->final_total = app(CurrencyService::class)->formateCurrency($is_promo_valid->original['data'][0]->final_total);
                $this->dispatch('validate_promo_code', is_promo_valid: $is_promo_valid->original);
            } else {
                if (isset($is_promo_valid->original['data']['final_total'])) {
                     $is_promo_valid->original['data']['final_total'] = app(CurrencyService::class)->formateCurrency($is_promo_valid->original['data']['final_total']);
                }
                $this->dispatch('validate_promo_code', is_promo_valid: $is_promo_valid->original);
            }
        }
        if ($this->is_wallet_use == true) {
            $wallet_balance = $wallet_balance - $final_total;
            if ($wallet_balance <= 0) {
                if ($wallet_balance < 0) {
                    $this->wallet_used_balance =  $final_total + $wallet_balance;
                    $final_total = - ($wallet_balance);
                } else {
                    $this->wallet_used_balance = $final_total;
                    $final_total = 0;
                }
                $wallet_balance = 0;
            } else {
                $this->wallet_used_balance = $final_total;
                $final_total = 0;
            }
        }
        $this->cart_count = (count($cart_data) >= 1) ? count($cart_data['cart_items']) : "";
        $this->store_id = $store_id;
        $bread_crumb = [
            'page_main_bread_crumb' => '<a wire:navigate href="' . customUrl('cart') . '">' . labels('front_messages.cart', 'Cart') . '</a>',
            'right_breadcrumb' => array(labels('front_messages.checkout', 'Checkout'))
        ];

        $pincode = $default_address[0]->pincode ?? "";
        $zipcode = fetchDetails(Zipcode::class, ['zipcode' => $pincode], 'id');
        $zipcode_id = $zipcode[0]->id ?? "";

        $city = $default_address[0]->city ?? "";
        $city_id = $default_address[0]->city_id ?? "";
        // dd($city_id);
        $settings = app(DeliveryService::class)->getDeliveryChargeSetting($store_id);
        // dd($settings);
        $product_availability = "";
        // dd($city_id);
        if (isset($settings[0]->product_deliverability_type) && !empty($settings[0]->product_deliverability_type)) {
            if ($settings[0]->product_deliverability_type == 'city_wise_deliverability') {
                $product_availability = app(DeliveryService::class)->checkCartProductsDeliverable($this->user_id, '', '', $store_id, $city, $city_id);
                //dd($product_availability);
            } else {
                // dd($zipcode_id);
                $product_availability = app(DeliveryService::class)->checkCartProductsDeliverable($this->user_id, $pincode, $zipcode_id, $store_id);
                //dd($product_availability);
            }
        }

        // ⭐ Filter product_availability if "Buy Now" mode is active
        if (!empty($this->buy_now_variant_id) && !empty($this->buy_now_product_type) && !empty($product_availability) && is_array($product_availability)) {
            $product_availability = $this->filterBuyNowProductAvailability($product_availability, $this->buy_now_variant_id, $this->buy_now_product_type);
        }
        // dd($product_availability);
        $time_slot_config = app(SettingService::class)->getSettings('time_slot_config', true);
        $time_slot_config = json_decode($time_slot_config);
        $time_slots = fetchDetails(TimeSlot::class, ['status' => 1]);

        $payment_method = app(SettingService::class)->getSettings('payment_method', true);
        $payment_method = json_decode($payment_method);
        Debugbar::info($payment_method);
        return view('livewire.' . config('constants.theme') . '.cart.checkout', [
            'cart_data' => $cart_data,
            'final_total' => $final_total,
            'product_availability' => $product_availability,
            'addresses' => $addresses,
            'promo_codes' => $promo_codes,
            'wallet_balance' => $wallet_balance,
            'default_address' => $default_address,
            'bread_crumb' => $bread_crumb,
            'time_slot_config' => $time_slot_config,
            'time_slots' => $time_slots,
            'payment_method' => $payment_method,
            'user_details' => $user_details,
        ])->title('Checkout |');
    }

    public function get_user_cart($user_id, $store_id, $address_id = "")
    {
        $cart_data = app(CartService::class)->getCartTotal($user_id, false, 0, $address_id, $store_id);
        return $cart_data;
    }

    public function get_selected_address($address_id)
    {
        $this->selected_address_id = $address_id;
        $addressController = app(AddressController::class);
        $selected_address = $addressController->getAddress($this->user_id, $address_id);
        $this->selected_address = $selected_address;
    }

    public function get_selected_promo($promo_code)
    {
        // dd($promo_code);
        $this->selected_promo_code = $promo_code;
    }
    public function is_wallet_use($is_wallet_use)
    {
        $this->is_wallet_use = $is_wallet_use;
    }

    public function validatePromoCode($promo_code, $user_id, $final_total)
    {
        $validate_promo = app(abstract: PromoCodeService::class)->validatePromoCode($promo_code, $user_id, $final_total);
        return $validate_promo;
    }

    public function refreshComponent()
    {
        $this->dispatch('$refresh');
    }

    public function remove_from_cart($id)
    {
        $data = [
            'variant_id' => $id,
            'product_type' => $this->product_type,
            'store_id' => $this->store_id,
            'user_id' => $this->user_id,
            'cart_count' => $this->cart_count,
        ];
        $this->dispatch('remove_from_cart', data: $data);
    }

    /**
     * Filter product availability to only include the "Buy Now" product
     */
    private function filterBuyNowProductAvailability($product_availability, $variant_id, $product_type)
    {
        if (empty($product_availability) || !is_array($product_availability)) {
            return $product_availability;
        }

        $filtered = [];
        foreach ($product_availability as $key => $availability) {
            // Handle both array and object structures
            if (is_object($availability)) {
                $item_variant_id = $availability->product_variant_id ?? $availability->variant_id ?? '';
                $item_product_type = $availability->product_type ?? $availability->cart_product_type ?? 'regular';
            } else {
                $item_variant_id = $availability['product_variant_id'] ?? $availability['variant_id'] ?? '';
                $item_product_type = $availability['product_type'] ?? $availability['cart_product_type'] ?? 'regular';
            }

            if ($item_variant_id == $variant_id && $item_product_type == $product_type) {
                $filtered[$key] = $availability;
            }
        }

        return $filtered;
    }
}
