<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class LanguageSyncController extends Controller
{
    public function sync(Request $request)
    {
        // ❌ NO TOKEN CHECK HERE

        $langCode = $request->lang_code;     // en, mr, hi
        $fileName = $request->file_name;     // front_messages.php
        $content  = $request->content;       // PHP content

        $dir = base_path("resources/lang/{$langCode}");

        if (!File::isDirectory($dir)) {
            File::makeDirectory($dir, 0755, true);
        }

        File::put($dir . '/' . $fileName, $content);

        return response()->json([
            'error' => false,
            'message' => 'Language file created successfully'
        ]);
    }
}
